// ساختار درختی منوی محصولات
document.addEventListener('DOMContentLoaded', function() {
    const menuContainer = document.getElementById('products-menu-container');
    
    if (menuContainer) {
        menuContainer.innerHTML = `
            <div class="products-menu">
                <div class="menu-label">فهرست محصولات</div>
                <div class="menu-content">
                    ${createMenuHTML(menuStructure)}
                </div>
            </div>
        `;
        
        // اضافه کردن event listener برای آیتم های منو
        setTimeout(() => {
            const categories = document.querySelectorAll('.menu-category');
            categories.forEach(category => {
                category.addEventListener('click', function(e) {
                    if (!this.classList.contains('has-link')) {
                        e.preventDefault();
                        this.classList.toggle('active');
                    }
                });
            });
        }, 100);
    }
});

// ساختار داده منو - نسخه جدید
const menuStructure = [
    {
        name: "تجهیزات اداری و دفتری",
        children: [
            {
                name: "کمد بایگانی",
                children: [
                    {
                        name: "ریلی",
                        children: [
                            { name: "TF-S11", link: "#", class: "disabled" },
                            { name: "TF-A11", link: "#", class: "disabled" },
                            { name: "TF-A12", link: "#", class: "disabled" },
                            { name: "TF-E11", link: "#", class: "disabled" }
                        ]
                    },
                    {
                        name: "هوشمند",
                        children: [
                            { name: "TF-E12", link: "#", class: "disabled" }
                        ]
                    },
                    {
                        name: "طبقه ای",
                        children: [
                            { name: "TF-A13", link: "#", class: "disabled" },
                            { name: "TS-A11", link: "#", class: "disabled" },
                            { name: "TS-A12", link: "#", class: "disabled" }
                        ]
                    },
                    {
                        name: "جاکلیدی",
                        children: [
                            { name: "TK-A11", link: "#", class: "disabled" }
                        ]
                    },
                    {
                        name: "دوار",
                        children: [
                            { name: "TF-A14", link: "TF-A14.htm" },
                            { name: "TF-A15", link: "TF-A15.htm" },
                            { name: "TF-A16", link: "#", class: "disabled" },
                            { name: "TF-A17", link: "#", class: "disabled" },
                            { name: "TF-A18", link: "#", class: "disabled" },
                            { name: "TF-A19", link: "TF-A19.htm" },
                            { name: "TF-A20", link: "#", class: "disabled" },
                            { name: "TF-A23", link: "TF-A23.htm" },
                            { name: "TF-A24", link: "TF-A24.htm" },
                            { name: "TF-A25", link: "TF-A25.htm" },
                            { name: "TF-A26", link: "TF-A26.htm" }
                        ]
                    }
                ]
            },
            {
                name: "قفسه کتابخانه",
                children: [
                    { name: "TR-A11", link: "#", class: "disabled" },
                    { name: "TR-A12", link: "#", class: "disabled" },
                    { name: "TR-A13", link: "#", class: "disabled" },
                    { name: "TR-A14", link: "TR-A14.htm" },
                    { name: "TR-A15", link: "#", class: "disabled" },
                    { name: "TR-A16", link: "TR-A16.htm" },
                    { name: "TR-A17", link: "#", class: "disabled" }
                ]
            },
            {
                name: "میز",
                children: [
                    { name: "TD-AB11", link: "TD-AB11.htm" },
                    { name: "TD-AB12", link: "#", class: "disabled" },
                    { name: "TD-AB13", link: "#", class: "disabled" },
                    { name: "TD-AG11", link: "#", class: "disabled" },
                    { name: "TD-MC11", link: "TD-MC11.htm" },
                    { name: "TD-SD02", link: "TD-SD02.htm" },
                    { name: "TD-CO01", link: "TD-CO01.htm" }
                ]
            },
            {
                name: "صندلی",
                children: [
                    {
                        name: "مدیریتی",
                        children: [
                            { name: "TH-AM11", link: "#", class: "disabled" },
                            { name: "TH-AM12", link: "#", class: "disabled" },
                            { name: "TH-AM13", link: "#", class: "disabled" },
                            { name: "TH-AM14", link: "#", class: "disabled" },
                            { name: "TH-AM15", link: "#", class: "disabled" },
                            { name: "TH-AM16", link: "#", class: "disabled" }
                        ]
                    },
                    {
                        name: "کارشناسی",
                        children: [
                            { name: "TH-AB11", link: "#", class: "disabled" },
                            { name: "TH-AB12", link: "#", class: "disabled" },
                            { name: "TH-AB13", link: "#", class: "disabled" },
                            { name: "TH-AB14", link: "#", class: "disabled" }
                        ]
                    }
                ]
            },
            {
                name: "پارتشین",
                children: [
                    { name: "TAL-METAL", link: "#", class: "disabled" }
                ]
            },
            {
                name: "پوشه، زونکن، جامجله ای",
                children: [
                    {
                        name: "پوشه",
                        children: [
                            { name: "TP-A11", link: "#", class: "disabled" },
                            { name: "TP-A18", link: "#", class: "disabled" },
                            { name: "TP-S11", link: "#", class: "disabled" }
                        ]
                    },
                    {
                        name: "زونکن",
                        children: [
                            { name: "TN-A11", link: "TN-A11.htm" },
                            { name: "TN-A12", link: "TN-A12.htm" },
                            { name: "TN-A13", link: "TN-A13.htm" },
                            { name: "TN-A14", link: "TN-A14.htm" },
                            { name: "TN-A15", link: "#", class: "disabled" },
                            { name: "TN-A16", link: "#", class: "disabled" },
                            { name: "TN-A17", link: "#", class: "disabled" }
                        ]
                    },
                    {
                        name: "جامجله ای",
                        children: [
                            { name: "TJ-A11", link: "#", class: "disabled" },
                            { name: "TJ-A12", link: "#", class: "disabled" },
                            { name: "TJ-A13", link: "#", class: "disabled" }
                        ]
                    }
                ]
            }
        ]
    },
    {
        name: "تجهیزات و امکانات رفاهی",
        children: [
            {
                name: "کمد رختکن",
                children: [
                    {
                        name: "تک پرسنلی",
                        children: [
                            { name: "TL-AA1", link: "TL-AA1.htm" },
                            { name: "TL-AB1", link: "TL-AB1.htm" },
                            { name: "TL-AC1", link: "TL-AC1.htm" },
                            { name: "TL-AD1", link: "TL-AD1.htm" },
                            { name: "TL-AE1", link: "#", class: "disabled" },
                            { name: "TL-AF1", link: "#", class: "disabled" }
                        ]
                    },
                    {
                        name: "دو پرسنلی",
                        children: [
                            { name: "TL-AA2", link: "TL-AA2.htm" },
                            { name: "TL-AB2", link: "#", class: "disabled" },
                            { name: "TL-AC2", link: "#", class: "disabled" },
                            { name: "TL-AD2", link: "#", class: "disabled" },
                            { name: "TL-AE2", link: "#", class: "disabled" },
                            { name: "TL-AF2", link: "#", class: "disabled" },
                            { name: "TL-AG2", link: "#", class: "disabled" },
                            { name: "TL-AH2", link: "#", class: "disabled" },
                            { name: "TL-AI2", link: "TL-AI2.htm" }
                        ]
                    },
                    {
                        name: "سه پرسنلی",
                        children: [
                            { name: "TL-AA3", link: "#", class: "disabled" },
                            { name: "TL-AB3", link: "#", class: "disabled" },
                            { name: "TL-AC3", link: "TL-AC3.htm" }
                        ]
                    },
                    {
                        name: "چهار پرسنلی",
                        children: [
                            { name: "TL-AA4", link: "TL-AA4.htm" },
                            { name: "TL-AB4", link: "TL-AB4.htm" }
                        ]
                    },
                    {
                        name: "شش پرسنلی",
                        children: [
                            { name: "TL-AA6", link: "TL-AA6.htm" },
                            { name: "TL-AB6", link: "TL-AB6.htm" }
                        ]
                    },
                    {
                        name: "هشت پرسنلی",
                        children: [
                            { name: "TL-AA8", link: "TL-AA8.htm" }
                        ]
                    },
                    {
                        name: "نه پرسنلی",
                        children: [
                            { name: "TL-AA9", link: "TL-AA9.htm" }
                        ]
                    },
                    {
                        name: "دوازده پرسنلی",
                        children: [
                            { name: "TL-AA12", link: "TL-AA12.htm" }
                        ]
                    },
                    {
                        name: "پانزده پرسنلی",
                        children: [
                            { name: "TL-AA15", link: "TL-AA15.htm" }
                        ]
                    }
                ]
            },
            {
                name: "کمد جاکفشی",
                children: [
                    { name: "TC-A18", link: "TC-A18.htm" },
                    { name: "TC-A24", link: "TC-A24.htm" },
                    { name: "TC-A27", link: "TC-A27.htm" },
                    { name: "TC-A30", link: "#", class: "disabled" }
                ]
            },
            {
                name: "تخت خوابگاهی",
                children: [
                    { name: "TB-A11", link: "TB-A11.htm" },
                    { name: "TB-A12", link: "TB-A12.htm" },
                    { name: "TB-A13", link: "TB-A13.htm" },
                    { name: "TB-A14", link: "#", class: "disabled" }
                ]
            },
            {
                name: "کمد ابزار",
                children: [
                    { name: "TO-A11", link: "#", class: "disabled" }
                ]
            },
            {
                name: "انتظار",
                children: [
                    { name: "TH-AW11", link: "#", class: "disabled" },
                    { name: "TH-AW12", link: "#", class: "disabled" }
                ]
            },
            {
                name: "سطل زباله",
                children: [
                    { name: "TX-A11", link: "#", class: "disabled" },
                    { name: "TX-A12", link: "#", class: "disabled" },
                    { name: "TX-A13", link: "#", class: "disabled" }
                ]
            }
        ]
    },
    {
        name: "اجزای محصول و آپشن",
        children: [
            {
                name: "غش گیر",
                children: [
                    { name: "TQ-A11", link: "#", class: "disabled" }
                ]
            }
        ]
    }
];

// تابع تولید HTML منو با سلسله مراتب
function createMenuHTML(menuData, level = 1) {
    let html = '';
    
    menuData.forEach(item => {
        if (item.children) {
            // آیتم های فارسی (دارای زیرمنو)
            html += `
                <div class="menu-item">
                    <div class="menu-category level-${level}">${item.name}</div>
                    <div class="menu-subcategory">
                        ${createMenuHTML(item.children, level + 1)}
                    </div>
                </div>
            `;
        } else {
            // آیتم های انگلیسی (لینک مستقیم)
            const linkClass = item.class ? `menu-link ${item.class}` : 'menu-link';
            html += `
                <div class="menu-item">
                    <a class="${linkClass}" href="${item.link}">${item.name}</a>
                </div>
            `;
        }
    });
    
    return html;
}